//**************************************************************************/
// Copyright (c) 2010 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/

// World-view-projection transformation.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;
float4 gMapColor = {0.0f, 0.0f, 0.0f, 1.0f};
float4 gBGColor = {1.0f, 1.0f, 1.0f, 0.0f};

texture2D gEdgeTexture;
texture2D gSilhouetteTexture;
texture2D gZHaloTexture;
texture2D gScene;
texture2D gSceneAlpha;

bool gUseScene;
bool gUseSceneAlpha;
bool gUseEdge;
bool gUseHalo;
bool gUseSilhouette;

sampler2D EdgeSampler = sampler_state
{
    Texture = <gEdgeTexture>;
};

sampler2D SilhouetteSampler = sampler_state
{
    Texture = <gSilhouetteTexture>;
};

sampler2D ZHaloSampler = sampler_state
{
    Texture = <gZHaloTexture>;
};

sampler2D SceneSampler = sampler_state
{
    Texture = <gScene>;
};

sampler2D SceneAlphaSampler = sampler_state
{
    Texture = <gSceneAlpha>;
};

struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader.
VS_TO_PS VS_NPR(VS_INPUT In)
{
    VS_TO_PS Out;

    // Transform the position from object space to clip space for output.
    Out.HPos = mul(In.Pos, gWVPXf);

    // Pass the texture coordinates unchanged.
    Out.UV = In.UV;

    return Out;
}

// Pixel shader.
float4 PS_NPR(VS_TO_PS In) : COLOR0
{
    // Please note that: the lines are black and the background is white.
    float e = gUseEdge ? (1.0f - tex2D(EdgeSampler, In.UV).r) : 0.0f;
    float s = gUseSilhouette ? (1.0f - tex2D(SilhouetteSampler, In.UV).r) : 0.0f;

    float z = gUseHalo ? tex2D(ZHaloSampler, In.UV).r : 0.0f;

    // Make sure non haloed areas with bigger silhouettes than edges get the same edge color for the overlapping area as the non overlapping.
    float res = s + e;
    res = min(res, 1.0f);

    res = res * (1.0f - z);

    float4 scene;

    // Either we have an input or the fill is white.
    if (gUseScene)
    {
        scene = tex2D(SceneSampler, In.UV);
    }
    else
    {
        scene = gBGColor;
    }

    if (gUseSceneAlpha)
    {
        scene.a = tex2D(SceneAlphaSampler, In.UV).a;
    }

    // 3ds Max need alpha output.
    float4 output = (1.0f - res) * scene + res * gMapColor;

    return output;
}

// The main technique.
technique Main
{
    pass p0
    {
#ifdef SHADER_MODEL_3
        VertexShader = compile vs_3_0 VS_NPR();
        PixelShader = compile ps_3_0 PS_NPR();
#else
        VertexShader = compile vs_2_0 VS_NPR();
        PixelShader = compile ps_2_0 PS_NPR();
#endif
    }
}

